//========================================================================================
//  
//  File: ConnectInstancesToESTK
//  
//  Owner: Archie Lim
//  
//  $Author: pmbuilder $
//  
//  $DateTime: 2010/02/22 14:31:38 $
//  
//  $Revision: #1 $
//  
//  $Change: 742152 $
//  
//  Copyright 1997-2009 Adobe Systems Incorporated. All rights reserved.
//  
//  NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance 
//  with the terms of the Adobe license agreement accompanying it.  If you have received
//  this file from a source other than Adobe, then your use, modification, or 
//  distribution of it requires the prior written permission of Adobe.
//  
//  This javascript is placed under the startup scripts folder so that when InDesign Server launches
//  and ESTK is already up, it will add a target for this specific instance of InDesignServer on the 
//  ESTK's drop down menu.
//  For example, if we have ESTK up and running, the drop down menu would only have 
//  "Adobe InDesign CS5 Server". When you run scripts against this, it will automatically launch an
// IDS in the background as a target. However, if we launch our own IDS instance, say, 
//  "InDesignServer.com -port 12345". ESTK will now have another line in the drop-down menu saying
//  "Adobe InDesign CS5 Server (configuration_12345)"
//  
//  Watson # 2251986
//========================================================================================

if (app.name == "Adobe InDesign Server") {
	if( BridgeTalk.isRunning( "estoolkit-3.5" ) )
	{
	   var b = new BridgeTalk;
	   b.target = "estoolkit-3.5#dbg";
	   b.body = "registerTarget( '" + BridgeTalk.appSpecifier + "' );";
	   b.send();
	}
}
